#include "../../../lib/std.mi"

Global Layer fx;
Global Layout thisl;
Global Vis _vis;
Global Double rp, dp, tp, ap;
Global Int ef;

FX.fx_onGetPixelA(double r, double d, double x, double y) {
  if (ef == 0) return cos(d*3.14159);
  return 1.0;
}

Fx.fx_onGetPixelR(double r, double d, double x, double y) {
  if (!ef || ef==1) return r+cos(rp);
  if (ef == 3) return r-rp;
  return r;
}

Fx.fx_onGetPixelD(double r, double d, double x, double y) {
  if (!ef || ef==2) return d*(1.3-sin(dp)) + cos(tp)*0.2;
  if (ef == 3) return d*(1.01+cos(rp*0.325));
  return d;
}

Fx.fx_onGetPixelY(double r, double d, double x, double y) {
  if (ef==4) return y+sin(x-rp);
  return y;
}

Fx.onLeftButtonDown(int x, int y) {
  ef = ef+1;
  if (ef == 6) 
    ef = 0;
  if (ef == 4) 
    Fx.fx_setRect(1); 
  else 
    Fx.fx_setRect(0);
  if (ef == 0) Fx.fx_setAlphaMode(1);
  else Fx.fx_setAlphaMode(0);

  Fx.fx_setWrap(0);
  if (ef == 0)
    Fx.fx_setGridSize(8,8);
  else if (ef == 1 || ef == 3) 
  {
    Fx.fx_setGridSize(1,1);
    Fx.fx_setWrap(1);
  }
  else if (ef == 2)
    Fx.fx_setGridSize(6,6);
  else if (ef == 4)
    Fx.fx_setGridSize(4,4);
}


Fx.fx_onFrame() {
  rp = rp + 1.2;
  dp = dp + 0.1;
  tp = tp + 0.3;
  ap = ap + 0.05;
}

thisl.onShow() {
  Fx.fx_setEnabled(1);
}

thisl.onHide() {
  Fx.fx_setEnabled(0);
}

System.onScriptLoaded() {

  thisl = getContainer("DMove").getLayout("Normal");
  Fx = thisl.getObject("logo");

  Fx.fx_setBgFx(0);
  Fx.fx_setWrap(0);
  Fx.fx_setBilinear(1);
  Fx.fx_setAlphaMode(1);
  Fx.fx_setGridSize(8,8);
  Fx.fx_setRect(0);
  Fx.fx_setClear(1);
  Fx.fx_setLocalized(1);
  Fx.fx_setRealtime(1);
  Fx.fx_setSpeed(100);
}

